/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import javax.inject.Inject;
import org.gradle.api.internal.artifacts.ResolveArtifactsBuildOperationType;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ParallelResolveArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.work.WorkerLeaseService;

@ServiceScope(value={Scope.Build.class})
public class ResolvedArtifactSetResolver {
    private final WorkerLeaseService workerLeaseService;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationExecutor buildOperationExecutor;
    private final DependencyVerificationOverride dependencyVerificationOverride;

    @Inject
    public ResolvedArtifactSetResolver(WorkerLeaseService workerLeaseService, BuildOperationRunner buildOperationRunner, BuildOperationExecutor buildOperationExecutor, DependencyVerificationOverride dependencyVerificationOverride) {
        this.workerLeaseService = workerLeaseService;
        this.buildOperationRunner = buildOperationRunner;
        this.buildOperationExecutor = buildOperationExecutor;
        this.dependencyVerificationOverride = dependencyVerificationOverride;
    }

    public void visitInUnmanagedWorkerThread(ResolvedArtifactSet artifacts, ArtifactVisitor visitor, ResolutionHost resolutionHost) {
        this.workerLeaseService.runAsUnmanagedWorkerThread(() -> this.visitArtifacts(artifacts, visitor, resolutionHost));
    }

    public void visitArtifacts(final ResolvedArtifactSet artifacts, final ArtifactVisitor visitor, final ResolutionHost resolutionHost) {
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                ParallelResolveArtifactSet.wrap(artifacts, ResolvedArtifactSetResolver.this.buildOperationExecutor).visit(visitor);
                ResolvedArtifactSetResolver.this.dependencyVerificationOverride.artifactsAccessed(resolutionHost.getDisplayName());
                context.setResult((Object)new ResolveArtifactsBuildOperationType.Result(){});
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve files of " + resolutionHost.getDisplayName();
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).details((Object)new ResolveArtifactsBuildOperationType.Details(){});
            }
        });
    }
}

