/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.internal.asn1;

import com.webauthn4j.util.UnsignedNumberUtil;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ASN1Length {
    private static final int LEADING_BIT_MASK = 128;
    private final boolean indefinite;
    private final int valueLength;

    static ASN1Length parse(ByteBuffer byteBuffer) {
        byte firstByte = byteBuffer.get();
        boolean longForm = (firstByte & 0x80) != 0;
        int valueLength = 0;
        if (!longForm) {
            valueLength = firstByte & 0xFFFFFF7F;
        } else {
            int octets = UnsignedNumberUtil.getUnsignedByte((byte)(firstByte & 0xFFFFFF7F));
            for (int i = 0; i < octets; ++i) {
                valueLength = valueLength * 256 + UnsignedNumberUtil.getUnsignedByte(byteBuffer.get());
            }
        }
        return new ASN1Length(longForm && valueLength == 0, valueLength);
    }

    ASN1Length(boolean indefinite, int valueLength) {
        this.indefinite = indefinite;
        this.valueLength = valueLength;
    }

    public boolean isIndefinite() {
        return this.indefinite;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ASN1Length asn1Length = (ASN1Length)o;
        return this.indefinite == asn1Length.indefinite && this.valueLength == asn1Length.valueLength;
    }

    public int hashCode() {
        return Objects.hash(this.indefinite, this.valueLength);
    }
}

