/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;

public class GroupPolicyRepresentation
extends AbstractPolicyRepresentation {
    private String groupsClaim;
    private Set<GroupDefinition> groups;

    @Override
    public String getType() {
        return "group";
    }

    public String getGroupsClaim() {
        return this.groupsClaim;
    }

    public void setGroupsClaim(String groupsClaim) {
        this.groupsClaim = groupsClaim;
    }

    public Set<GroupDefinition> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<GroupDefinition> groups) {
        this.groups = groups;
    }

    public void addGroup(String ... ids) {
        for (String id : ids) {
            this.addGroup(id, false);
        }
    }

    public void addGroup(String id, boolean extendChildren) {
        if (this.groups == null) {
            this.groups = new HashSet<GroupDefinition>();
        }
        this.groups.add(new GroupDefinition(id, extendChildren));
    }

    public void addGroupPath(String ... paths) {
        for (String path : paths) {
            this.addGroupPath(path, false);
        }
    }

    public void addGroupPath(String path, boolean extendChildren) {
        if (this.groups == null) {
            this.groups = new HashSet<GroupDefinition>();
        }
        this.groups.add(new GroupDefinition(null, path, extendChildren));
    }

    public void removeGroup(String ... ids) {
        if (this.groups != null) {
            for (String id : ids) {
                Iterator<GroupDefinition> iterator = this.groups.iterator();
                while (iterator.hasNext()) {
                    GroupDefinition group = iterator.next();
                    if (!id.equals(group.getId()) && (group.getPath() == null || !group.getPath().equals(id))) continue;
                    iterator.remove();
                }
            }
        }
    }

    public static class GroupDefinition
    implements Comparable<GroupDefinition> {
        private String id;
        private String path;
        private boolean extendChildren;

        public GroupDefinition() {
            this(null);
        }

        public GroupDefinition(String id) {
            this(id, false);
        }

        public GroupDefinition(String id, boolean extendChildren) {
            this(id, null, extendChildren);
        }

        public GroupDefinition(String id, String path, boolean extendChildren) {
            this.id = id;
            this.path = path;
            this.extendChildren = extendChildren;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isExtendChildren() {
            return this.extendChildren;
        }

        public void setExtendChildren(boolean extendChildren) {
            this.extendChildren = extendChildren;
        }

        @Override
        public int compareTo(GroupDefinition o) {
            if (o.id == null || this.id == null) {
                return 1;
            }
            return this.id.compareTo(o.id);
        }
    }
}

