/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.headers.Header;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedContent;
import org.openapitools.openapidiff.core.model.ChangedExample;
import org.openapitools.openapidiff.core.model.ChangedExamples;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedHeader
implements ComposedChanged {
    private final Header oldHeader;
    private final Header newHeader;
    private final DiffContext context;
    private boolean required;
    private boolean deprecated;
    private boolean style;
    private boolean explode;
    private ChangedMetadata description;
    private ChangedExamples examples;
    private ChangedExample example;
    private ChangedSchema schema;
    private ChangedContent content;
    private ChangedExtensions extensions;

    public ChangedHeader(Header oldHeader, Header newHeader, DiffContext context) {
        this.oldHeader = oldHeader;
        this.newHeader = newHeader;
        this.context = context;
    }

    @Override
    public List<Changed> getChangedElements() {
        return Arrays.asList(this.description, this.example, this.examples, this.schema, this.content, this.extensions);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (!(this.required || this.deprecated || this.style || this.explode)) {
            return DiffResult.NO_CHANGES;
        }
        if (this.explode && BackwardIncompatibleProp.RESPONSE_HEADER_EXPLODE_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.required) {
            boolean requiredNew;
            boolean requiredOld = this.oldHeader.getRequired() != null ? this.oldHeader.getRequired() : false;
            boolean bl = requiredNew = this.newHeader.getRequired() != null ? this.newHeader.getRequired() : false;
            if (requiredOld && !requiredNew && BackwardIncompatibleProp.RESPONSE_HEADER_REQUIRED_DECREASED.enabled(this.context, new Object[0])) {
                return DiffResult.INCOMPATIBLE;
            }
            if (!requiredOld && requiredNew && BackwardIncompatibleProp.RESPONSE_HEADER_REQUIRED_INCREASED.enabled(this.context, new Object[0])) {
                return DiffResult.INCOMPATIBLE;
            }
        }
        if (this.style) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public Header getOldHeader() {
        return this.oldHeader;
    }

    public Header getNewHeader() {
        return this.newHeader;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isStyle() {
        return this.style;
    }

    public boolean isExplode() {
        return this.explode;
    }

    public ChangedMetadata getDescription() {
        return this.description;
    }

    public ChangedExamples getExamples() {
        return this.examples;
    }

    public ChangedExample getExample() {
        return this.example;
    }

    public ChangedSchema getSchema() {
        return this.schema;
    }

    public ChangedContent getContent() {
        return this.content;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedHeader setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public ChangedHeader setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public ChangedHeader setStyle(boolean style) {
        this.style = style;
        return this;
    }

    public ChangedHeader setExplode(boolean explode) {
        this.explode = explode;
        return this;
    }

    public ChangedHeader setDescription(ChangedMetadata description) {
        this.description = description;
        return this;
    }

    public ChangedHeader setExamples(ChangedExamples examples) {
        this.examples = examples;
        return this;
    }

    public ChangedHeader setExample(ChangedExample example) {
        this.example = example;
        return this;
    }

    public ChangedHeader setSchema(ChangedSchema schema) {
        this.schema = schema;
        return this;
    }

    public ChangedHeader setContent(ChangedContent content) {
        this.content = content;
        return this;
    }

    public ChangedHeader setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedHeader that = (ChangedHeader)o;
        return this.required == that.required && this.deprecated == that.deprecated && this.style == that.style && this.explode == that.explode && Objects.equals(this.oldHeader, that.oldHeader) && Objects.equals(this.newHeader, that.newHeader) && Objects.equals(this.context, that.context) && Objects.equals(this.description, that.description) && Objects.equals(this.examples, that.examples) && Objects.equals(this.example, that.example) && Objects.equals(this.schema, that.schema) && Objects.equals(this.content, that.content) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.oldHeader, this.newHeader, this.context, this.required, this.deprecated, this.style, this.explode, this.description, this.examples, this.example, this.schema, this.content, this.extensions);
    }

    public String toString() {
        return "ChangedHeader(oldHeader=" + this.getOldHeader() + ", newHeader=" + this.getNewHeader() + ", context=" + this.getContext() + ", required=" + this.isRequired() + ", deprecated=" + this.isDeprecated() + ", style=" + this.isStyle() + ", explode=" + this.isExplode() + ", description=" + this.getDescription() + ", examples=" + this.getExamples() + ", example=" + this.getExample() + ", schema=" + this.getSchema() + ", content=" + this.getContent() + ", extensions=" + this.getExtensions() + ")";
    }
}

