/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.UniqueCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class UniqueFunction
extends LongValue.AbstractLongValue
implements ReductionFunction {
    private UniqueCollector<?> collector;
    public static final String name = "unique";
    private final String exprStr;
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        UniqueCollector collector;
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The unique function requires 1 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof IntValueStream) {
            collector = new UniqueCollector.UniqueIntCollector((IntValueStream)param);
        } else if (param instanceof LongValueStream) {
            collector = new UniqueCollector.UniqueLongCollector((LongValueStream)param);
        } else if (param instanceof FloatValueStream) {
            collector = new UniqueCollector.UniqueFloatCollector((FloatValueStream)param);
        } else if (param instanceof DoubleValueStream) {
            collector = new UniqueCollector.UniqueDoubleCollector((DoubleValueStream)param);
        } else if (param instanceof StringValueStream) {
            collector = new UniqueCollector.UniqueStringCollector((StringValueStream)param);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The unique function requires a comparable parameter.");
        }
        return new UniqueFunction(param, collector);
    };

    public UniqueFunction(AnalyticsValueStream param, UniqueCollector<?> collector) {
        this.collector = collector;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    @Override
    public long getLong() {
        return this.collector.count();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (UniqueCollector)sync.apply(this.collector);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

