/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;

public class NumericLabelFilter
extends SingleLabelFilterBase {
    public NumericLabelFilter() {
        super("Numeric label filter enabled");
    }

    @Override
    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        short[] type = context.allWords.type;
        int[] wordIndices = context.allPhrases.wordIndices[phraseIndex];
        return !this.isNumeric(type[wordIndices[0]]);
    }

    @Override
    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        return !this.isNumeric(context.allWords.type[wordIndex]);
    }

    private boolean isNumeric(short type) {
        return (type & 0xF) == 2;
    }
}

