/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.nio.ByteBuffer;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;

public class SampleFlags {
    private byte reserved;
    private byte isLeading;
    private byte sampleDependsOn;
    private byte sampleIsDependedOn;
    private byte sampleHasRedundancy;
    private byte samplePaddingValue;
    private boolean sampleIsDifferenceSample;
    private int sampleDegradationPriority;

    public SampleFlags() {
    }

    public SampleFlags(ByteBuffer bb) {
        long a = IsoTypeReader.readUInt32(bb);
        this.reserved = (byte)((a & 0xFFFFFFFFF0000000L) >> 28);
        this.isLeading = (byte)((a & 0xC000000L) >> 26);
        this.sampleDependsOn = (byte)((a & 0x3000000L) >> 24);
        this.sampleIsDependedOn = (byte)((a & 0xC00000L) >> 22);
        this.sampleHasRedundancy = (byte)((a & 0x300000L) >> 20);
        this.samplePaddingValue = (byte)((a & 0xE0000L) >> 17);
        this.sampleIsDifferenceSample = (a & 0x10000L) >> 16 > 0L;
        this.sampleDegradationPriority = (int)(a & 0xFFFFL);
    }

    public void getContent(ByteBuffer os) {
        long a = 0L;
        a |= (long)(this.reserved << 28);
        a |= (long)(this.isLeading << 26);
        a |= (long)(this.sampleDependsOn << 24);
        a |= (long)(this.sampleIsDependedOn << 22);
        a |= (long)(this.sampleHasRedundancy << 20);
        a |= (long)(this.samplePaddingValue << 17);
        a |= (long)((this.sampleIsDifferenceSample ? 1 : 0) << 16);
        IsoTypeWriter.writeUInt32(os, a |= (long)this.sampleDegradationPriority);
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = (byte)reserved;
    }

    public byte getIsLeading() {
        return this.isLeading;
    }

    public void setIsLeading(byte isLeading) {
        this.isLeading = isLeading;
    }

    public int getSampleDependsOn() {
        return this.sampleDependsOn;
    }

    public void setSampleDependsOn(int sampleDependsOn) {
        this.sampleDependsOn = (byte)sampleDependsOn;
    }

    public int getSampleIsDependedOn() {
        return this.sampleIsDependedOn;
    }

    public void setSampleIsDependedOn(int sampleIsDependedOn) {
        this.sampleIsDependedOn = (byte)sampleIsDependedOn;
    }

    public int getSampleHasRedundancy() {
        return this.sampleHasRedundancy;
    }

    public void setSampleHasRedundancy(int sampleHasRedundancy) {
        this.sampleHasRedundancy = (byte)sampleHasRedundancy;
    }

    public int getSamplePaddingValue() {
        return this.samplePaddingValue;
    }

    public void setSamplePaddingValue(int samplePaddingValue) {
        this.samplePaddingValue = (byte)samplePaddingValue;
    }

    public boolean isSampleIsDifferenceSample() {
        return this.sampleIsDifferenceSample;
    }

    public void setSampleIsDifferenceSample(boolean sampleIsDifferenceSample) {
        this.sampleIsDifferenceSample = sampleIsDifferenceSample;
    }

    public int getSampleDegradationPriority() {
        return this.sampleDegradationPriority;
    }

    public void setSampleDegradationPriority(int sampleDegradationPriority) {
        this.sampleDegradationPriority = sampleDegradationPriority;
    }

    public String toString() {
        return "SampleFlags{reserved=" + this.reserved + ", isLeading=" + this.isLeading + ", depOn=" + this.sampleDependsOn + ", isDepOn=" + this.sampleIsDependedOn + ", hasRedundancy=" + this.sampleHasRedundancy + ", padValue=" + this.samplePaddingValue + ", isDiffSample=" + this.sampleIsDifferenceSample + ", degradPrio=" + this.sampleDegradationPriority + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampleFlags that = (SampleFlags)o;
        if (this.isLeading != that.isLeading) {
            return false;
        }
        if (this.reserved != that.reserved) {
            return false;
        }
        if (this.sampleDegradationPriority != that.sampleDegradationPriority) {
            return false;
        }
        if (this.sampleDependsOn != that.sampleDependsOn) {
            return false;
        }
        if (this.sampleHasRedundancy != that.sampleHasRedundancy) {
            return false;
        }
        if (this.sampleIsDependedOn != that.sampleIsDependedOn) {
            return false;
        }
        if (this.sampleIsDifferenceSample != that.sampleIsDifferenceSample) {
            return false;
        }
        return this.samplePaddingValue == that.samplePaddingValue;
    }

    public int hashCode() {
        int result = this.reserved;
        result = 31 * result + this.isLeading;
        result = 31 * result + this.sampleDependsOn;
        result = 31 * result + this.sampleIsDependedOn;
        result = 31 * result + this.sampleHasRedundancy;
        result = 31 * result + this.samplePaddingValue;
        result = 31 * result + (this.sampleIsDifferenceSample ? 1 : 0);
        result = 31 * result + this.sampleDegradationPriority;
        return result;
    }
}

